package gov.va.vinci.dart.db;

import java.util.List;

import gov.va.vinci.dart.common.exception.ObjectNotFoundException;
import gov.va.vinci.dart.biz.OperationalRequest;

public interface OperationalRequestDAO {

	void save(final OperationalRequest request);
	OperationalRequest findById(final int requestId) throws ObjectNotFoundException;
	List<OperationalRequest> listByActivityId(final int activityId);
	List<OperationalRequest> listByRequestor(final int requestorId);
	List<OperationalRequest> listAll();
	List<OperationalRequest> listRecentByRequestor(final int requestorId, final int maxResults);
	List<OperationalRequest> listByName(final int requestorId, final String key);
	List<OperationalRequest> listAllButInitiated();
	List<OperationalRequest> listAllSubmitted();
	OperationalRequest findMostRecentAmendment(final int headId);
}